/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.electric_switch;

import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ElectricSwitchBlockEntity
extends VoltageAlteringBlockEntity {
    int signal;
    boolean signalChanged;

    public ElectricSwitchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.level.getBestNeighborSignal(this.worldPosition));
        }
    }

    protected void analogSignalChanged(int newSignal) {
        this.signal = newSignal;
        this.updateInFrontNextTick();
        this.updateNextTick();
    }

    public void neighbourChanged() {
        if (!this.hasLevel()) {
            return;
        }
        int power = this.level.getBestNeighborSignal(this.worldPosition);
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }

    @Override
    public int getOutputVoltage() {
        return (int)((float)this.data.getVoltage() * ((float)this.signal / 15.0f));
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getOpposite();
    }
}

