/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.voltage_observer;

import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ObservedElectricBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<ObservedElectricBehaviour> TYPE = new BehaviourType();
    BlockPos observedPos;

    public ObservedElectricBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public BlockPos getObservedPos() {
        return this.observedPos;
    }

    public void setObservedPos(BlockPos observedPos) {
        this.observedPos = observedPos;
    }

    public void tick() {
        super.tick();
        if (this.getObservedPos() != null && !this.isObservingElectric()) {
            this.setObservedPos(null);
        }
    }

    public boolean isObservingElectric() {
        if (this.getObservedPos() == null) {
            return false;
        }
        BlockEntity be = this.getWorld().getBlockEntity(this.getObservedPos());
        return be instanceof IElectric;
    }

    public IElectric getObservedElectric() {
        if (!this.isObservingElectric()) {
            return null;
        }
        BlockEntity be = this.getWorld().getBlockEntity(this.getObservedPos());
        if (be instanceof IElectric) {
            IElectric electric = (IElectric)be;
            return electric;
        }
        throw new IllegalStateException("Observed position does not contain an IElectric block entity: " + String.valueOf(this.getObservedPos()));
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        if (this.observedPos != null) {
            nbt.put("ObservedPos", NbtUtils.writeBlockPos((BlockPos)this.observedPos));
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        Optional pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"ObservedPos");
        this.setObservedPos(pos.orElse(null));
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }
}

