/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.large_engine;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.engines.base.AbstractEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.base.EngineFluidTank;
import com.drmangotea.tfmg.content.engines.types.large_engine.LargeEngineBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class LargeEngineBlockEntity
extends AbstractEngineBlockEntity {
    public WeakReference<PoweredShaftBlockEntity> target = new WeakReference<Object>(null);
    public EngineFluidTank airTank;
    public IFluidHandler fluidCapabilityy;
    float prevAngle = 0.0f;

    public LargeEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.exhaustTank = new EngineFluidTank(2000, true, false, f -> this.tankUpdated((FluidStack)f, false));
        this.fuelTank = new EngineFluidTank(2000, false, true, f -> this.tankUpdated((FluidStack)f, true), TFMGTags.TFMGFluidTags.AIR.tag);
        this.airTank = new EngineFluidTank(1000, false, true, TFMGTags.TFMGFluidTags.AIR.tag, f -> this.tankUpdated((FluidStack)f, true));
        this.fluidCapabilityy = new CombinedTankWrapper(new IFluidHandler[]{this.exhaustTank, this.fuelTank, this.airTank});
    }

    @Override
    public void tankUpdated(FluidStack stack, boolean fuelTank) {
        super.tankUpdated(stack, fuelTank);
        this.sendStuff();
    }

    @Override
    public void refreshCapability() {
    }

    @Override
    public List<TagKey<Fluid>> getSupportedFuels() {
        return List.of(TFMGTags.TFMGFluidTags.DIESEL.tag, TFMGTags.TFMGFluidTags.KEROSENE.tag, TFMGTags.TFMGFluidTags.NAPHTHA.tag, TFMGTags.TFMGFluidTags.FURNACE_GAS.tag);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    public boolean isSimpleEngine() {
        return TFMGBlocks.SIMPLE_LARGE_ENGINE.has(this.getBlockState());
    }

    @Override
    public IFluidHandler handlerForCapability() {
        return new CombinedTankWrapper(new IFluidHandler[]{this.fuelTank, this.exhaustTank, this.airTank});
    }

    @Override
    public void manageFuelAndExhaust() {
        super.manageFuelAndExhaust();
        if (this.fuelConsumptionTimer > 2) {
            this.airTank.forceDrain(150, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void tick() {
        super.tick();
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (shaft == null && !this.level.isClientSide()) {
            if (shaft == null) {
                return;
            }
            if (!shaft.getBlockPos().subtract((Vec3i)this.worldPosition).equals((Object)shaft.enginePos)) {
                return;
            }
            if (shaft.engineEfficiency == 0.0f) {
                return;
            }
            Direction facing = LargeEngineBlock.getFacing(this.getBlockState());
            if (this.level.isLoaded(this.worldPosition.relative(facing.getOpposite()))) {
                shaft.update(this.worldPosition, 0, 0.0f);
            }
            return;
        }
        BlockState blockState = this.getBlockState();
        if (!TFMGBlocks.LARGE_ENGINE.has(blockState) && !TFMGBlocks.SIMPLE_LARGE_ENGINE.has(blockState)) {
            return;
        }
        if (this.level.isClientSide) {
            this.makeSound();
        }
        if (!this.level.isClientSide && this.getShaft() != null) {
            this.engineProcess();
        }
    }

    @Override
    public float efficiencyModifier() {
        return 0.5f;
    }

    @Override
    public float speedModifier() {
        return 1.0f;
    }

    @Override
    public float torqueModifier() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void makeSound() {
        float angle;
        Float targetAngle = this.getTargetAngle();
        PoweredShaftBlockEntity ste = (PoweredShaftBlockEntity)this.target.get();
        if (ste == null) {
            return;
        }
        if (this.getShaft().getSpeed() == 0.0f) {
            return;
        }
        if (this.fuelTank.isEmpty() || this.airTank.isEmpty() || this.exhaustTank.getSpace() == 0) {
            return;
        }
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (targetAngle == null) {
            return;
        }
        angle += (angle = AngleHelper.deg((double)targetAngle.floatValue())) < 0.0f ? -105.0f : 285.0f;
        angle %= 360.0f;
        if (shaft == null || shaft.getSpeed() == 0.0f) {
            return;
        }
        if (!(!(angle >= 0.0f) || this.prevAngle > 180.0f && angle < 180.0f)) {
            this.prevAngle = angle;
            return;
        }
        if (!(!(angle < 0.0f) || this.prevAngle < -180.0f && angle > -180.0f)) {
            this.prevAngle = angle;
            return;
        }
        TFMGSoundEvents.DIESEL_ENGINE.playAt(this.level, (Vec3i)this.worldPosition, 0.4f * TFMGConfigs.common().machines.engineLoudness.getF(), 1.0f, false);
        this.prevAngle = angle;
    }

    @Override
    public boolean canWork() {
        if (this.airTank.isEmpty()) {
            return false;
        }
        return super.canWork();
    }

    private void engineProcess() {
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (!this.canWork()) {
            shaft.update(this.worldPosition, 0, 0.0f);
            return;
        }
        boolean isFuelValid = false;
        for (TagKey<Fluid> tag : this.getSupportedFuels()) {
            if (!this.fuelTank.getFluid().getFluid().is(tag)) continue;
            isFuelValid = true;
        }
        shaft.update(this.worldPosition, 2, 15.0f * this.getFuelType().getStress() * (float)(isFuelValid ? 1 : 0));
        this.sendData();
        this.setChanged();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getShaft() == null) {
            return false;
        }
        TFMGLang.text("").style(ChatFormatting.GRAY).forGoggles(tooltip);
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    @Override
    public void remove() {
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (shaft != null) {
            shaft.remove(this.worldPosition);
        }
        super.remove();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    public PoweredShaftBlockEntity getShaft() {
        PoweredShaftBlockEntity shaft = (PoweredShaftBlockEntity)this.target.get();
        if (shaft == null || shaft.isRemoved() || !shaft.canBePoweredBy(this.worldPosition)) {
            PoweredShaftBlockEntity ps;
            Direction facing;
            BlockEntity anyShaftAt;
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            if ((anyShaftAt = this.level.getBlockEntity(this.worldPosition.relative(facing = LargeEngineBlock.getFacing(this.getBlockState()), 2))) instanceof PoweredShaftBlockEntity && (ps = (PoweredShaftBlockEntity)anyShaftAt).canBePoweredBy(this.worldPosition)) {
                shaft = ps;
                this.target = new WeakReference<PoweredShaftBlockEntity>(shaft);
            }
        }
        return shaft;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Float getTargetAngle() {
        float angle = 0.0f;
        BlockState blockState = this.getBlockState();
        if (!TFMGBlocks.LARGE_ENGINE.has(blockState) && !TFMGBlocks.SIMPLE_LARGE_ENGINE.has(blockState)) {
            return null;
        }
        Direction facing = SteamEngineBlock.getFacing((BlockState)blockState);
        PoweredShaftBlockEntity shaft = this.getShaft();
        Direction.Axis facingAxis = facing.getAxis();
        Direction.Axis axis = Direction.Axis.Y;
        if (shaft == null) {
            return null;
        }
        axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        angle = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)shaft, (BlockPos)shaft.getBlockPos(), (Direction.Axis)axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.isHorizontal() && facingAxis == Direction.Axis.X ^ facing.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            angle *= -1.0f;
        }
        if (axis == Direction.Axis.X && facing == Direction.DOWN) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    @Override
    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("Air", (Tag)this.airTank.writeToNBT(registries, new CompoundTag()));
        super.write(compound, registries, clientPacket);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.LARGE_ENGINE.get(), (be, context) -> be.fluidCapabilityy);
    }

    @Override
    public int getFuelConsumption() {
        if (this.getShaft() == null) {
            return 0;
        }
        if (this.isSimpleEngine() && this.getShaft() != null) {
            return (int)this.getShaft().getGeneratedSpeed() / 10;
        }
        if (this.getShaft() == null) {
            return 0;
        }
        return (int)this.getShaft().getGeneratedSpeed() / 40;
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.airTank.readFromNBT(registries, compound.getCompound("Air"));
        super.read(compound, registries, clientPacket);
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void notifyUpdate() {
        super.notifyUpdate();
    }
}

