/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_furnace;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class BlastFurnaceHatchBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public FluidTank tank;
    public SmartInventory inventory;
    public IFluidHandler fluidCapability;
    public IItemHandlerModifiable itemCapability;

    public BlastFurnaceHatchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.tank = TFMGUtils.createTank(4000, true, this::onFluidChanged);
        this.inventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(64);
        this.fluidCapability = this.tank;
        this.itemCapability = this.inventory;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.BLAST_FURNACE_HATCH.get(), (be, context) -> be.fluidCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.BLAST_FURNACE_HATCH.get(), (be, context) -> be.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
    }

    public void lazyTick() {
        super.lazyTick();
        this.dropItems();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    public void dropItems() {
        if (this.level.getBlockState(this.getBlockPos().below()).isAir()) {
            if (this.inventory.getItem(0).getItem() == Items.AIR) {
                return;
            }
            Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, -0.75, 0.0);
            ItemEntity dropped = new ItemEntity(this.level, dropVec.x, dropVec.y, dropVec.z, this.inventory.getItem(0).copy());
            dropped.setDefaultPickUpDelay();
            dropped.setDeltaMovement(0.0, -0.25, 0.0);
            this.level.addFreshEntity((Entity)dropped);
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.tank.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("TankContent", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
    }

    private void onFluidChanged(FluidStack stack) {
        if (!this.hasLevel()) {
            return;
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }
}

