/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.firebox;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.misc.firebox.FireboxBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FireboxBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    protected IFluidHandler fluidCapability;
    protected FluidTank tankInventory;
    protected FluidTank exhuastTank;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected boolean updateCapability;
    protected int width;
    protected int height;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    boolean running = false;

    public FireboxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(60);
        this.tankInventory = TFMGUtils.createTank(FireboxBlockEntity.getCapacityMultiplier(), false, true, this::onFluidStackChanged);
        this.exhuastTank = TFMGUtils.createTank(FireboxBlockEntity.getCapacityMultiplier(), true, false, this::onFluidStackChanged);
        this.fluidCapability = new CombinedTankWrapper(new IFluidHandler[]{this.tankInventory, this.exhuastTank});
        this.updateConnectivity = false;
        this.updateCapability = false;
        this.height = 1;
        this.width = 1;
        this.refreshCapability();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.FIREBOX.get(), (be, context) -> be.fluidCapability);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void lazyTick() {
        FireboxBlockEntity controller;
        super.lazyTick();
        boolean wasRunning = this.running;
        FireboxBlockEntity fireboxBlockEntity = controller = this.isController() ? this : this.getControllerBE();
        if (!this.canBurn(controller)) {
            if (wasRunning) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(FireboxBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE), 2);
            }
            this.running = false;
        } else {
            if (!wasRunning) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(FireboxBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.FADING), 2);
            }
            this.running = true;
            TFMGUtils.drainFilteredTank((SmartFluidTank)controller.tankInventory, 50);
            if (((Boolean)TFMGConfigs.common().machines.fireboxExhaustRequirement.get()).booleanValue()) {
                TFMGUtils.fillFilteredTank((SmartFluidTank)controller.exhuastTank, new FluidStack((Fluid)TFMGFluids.CARBON_DIOXIDE.get(), 500));
            }
        }
    }

    public boolean canBurn(FireboxBlockEntity controller) {
        if (this.exhuastTank == null) {
            return false;
        }
        return controller.exhuastTank.getSpace() > 0 && controller.tankInventory.getFluidAmount() >= (Integer)TFMGConfigs.common().machines.fireboxFuelConsumption.get() && controller.tankInventory.getFluid().getFluid().is(TFMGTags.TFMGFluidTags.FIREBOX_FUEL.tag);
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.level.isClientSide) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        this.setChanged();
        this.sendData();
    }

    public FireboxBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof FireboxBlockEntity) {
            return (FireboxBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * FireboxBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void removeController(boolean keepFluids) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    private void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? new CombinedTankWrapper(new IFluidHandler[]{this.tankInventory, this.exhuastTank}) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public FireboxBlockEntity getOtherFireboxBlockEntity(Direction direction) {
        BlockEntity otherBE = this.level.getBlockEntity(this.worldPosition.relative(direction));
        if (otherBE instanceof FireboxBlockEntity) {
            return (FireboxBlockEntity)otherBE;
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        FireboxBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.fluidCapability);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        compound.getBoolean("IsRunning");
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"LastKnownPos").get();
        }
        if (compound.contains("Controller")) {
            this.controller = (BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"Controller").get();
        }
        if (this.isController()) {
            this.width = compound.getInt("Size");
            this.height = compound.getInt("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * FireboxBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
            this.exhuastTank.setCapacity(this.getTotalTankSize() * FireboxBlockEntity.getCapacityMultiplier());
            this.exhuastTank.readFromNBT(registries, compound.getCompound("Exhaust"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.exhuastTank.getSpace() < 0) {
                this.exhuastTank.drain(-this.exhuastTank.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FireboxBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("IsRunning", this.running);
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
            compound.put("Exhaust", (Tag)this.exhuastTank.writeToNBT(registries, new CompoundTag()));
            compound.putInt("Size", this.width);
            compound.putInt("Height", this.height);
        }
        super.write(compound, registries, clientPacket);
    }

    public void invalidate() {
        super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN});
    }

    public IFluidTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return 1;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (FluidTankBlock.isTank((BlockState)state)) {
            state = (BlockState)state.setValue((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.height - 1 == this.getBlockPos().getY()));
            this.level.setBlock(this.getBlockPos(), state, 6);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return FireboxBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return FireboxBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }
}

