/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.mixin;

import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.measurement.MultimeterItem;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.mixin.accessor.MouseHandlerAccessor;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.Map;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GoggleOverlayRenderer.class})
public class GoggleOverlayRendererMixin {
    @Shadow
    private static final Map<Object, Outliner.OutlineEntry> outlines = Outliner.getInstance().getOutlines();
    private static int tfmg$hoverTicks = 0;
    private static BlockPos tfmg$lastHovered = null;

    @Inject(at={@At(value="HEAD")}, method={"renderOverlay"}, cancellable=true, remap=false)
    private static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        HitResult objectMouseOver = mc.hitResult;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            tfmg$lastHovered = null;
            tfmg$hoverTicks = 0;
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        BlockPos pos = result.getBlockPos();
        pos = GoggleOverlayRendererMixin.proxiedOverlayPosition((Level)world, pos);
        BlockEntity be = world.getBlockEntity(pos);
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        ++tfmg$hoverTicks;
        tfmg$lastHovered = pos;
        boolean holdsMultimeter = MultimeterItem.isHeldByPlayer((Player)mc.player);
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)mc.player);
        boolean isShifting = mc.player.isShiftKeyDown();
        boolean isElectricBlock = be instanceof IElectric;
        if (isElectricBlock && !hasGoggles) {
            ItemStack item = TFMGItems.MULTIMETER.asStack();
            ArrayList<Component> tooltip = new ArrayList<Component>();
            ((IElectric)be).makeMultimeterTooltip(tooltip, isShifting);
            if (!isElectricBlock || !holdsMultimeter) {
                tfmg$hoverTicks = 0;
            } else if (tooltip.isEmpty()) {
                tfmg$hoverTicks = 0;
            } else {
                Color colorBorderBot;
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                int tooltipTextWidth = 0;
                for (FormattedText formattedText : tooltip) {
                    int textLineWidth = mc.font.width(formattedText);
                    if (textLineWidth <= tooltipTextWidth) continue;
                    tooltipTextWidth = textLineWidth;
                }
                int tooltipHeight = 8;
                if (tooltip.size() > 1) {
                    tooltipHeight += 2;
                    tooltipHeight += (tooltip.size() - 1) * 10;
                }
                int n = guiGraphics.guiWidth();
                int height = guiGraphics.guiHeight();
                CClient cfg = AllConfigs.client();
                int posX = n / 2 + (Integer)cfg.overlayOffsetX.get();
                int posY = height / 2 + (Integer)cfg.overlayOffsetY.get();
                posX = Math.min(posX, n - tooltipTextWidth - 20);
                posY = Math.min(posY, height - tooltipHeight - 20);
                float fade = Mth.clamp((float)(((float)tfmg$hoverTicks + deltaTracker.getGameTimeDeltaPartialTick(false)) / 24.0f), (float)0.0f, (float)1.0f);
                Boolean useCustom = (Boolean)cfg.overlayCustomColor.get();
                Color colorBackground = useCustom != false ? new Color(((Integer)cfg.overlayBackgroundColor.get()).intValue()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
                Color colorBorderTop = useCustom != false ? new Color(((Integer)cfg.overlayBorderColorTop.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getFirst()).copy();
                Color color = colorBorderBot = useCustom != false ? new Color(((Integer)cfg.overlayBorderColorBot.get()).intValue()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getSecond()).copy();
                if (fade < 1.0f) {
                    poseStack.translate(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
                    colorBackground.scaleAlpha(fade);
                    colorBorderTop.scaleAlpha(fade);
                    colorBorderBot.scaleAlpha(fade);
                }
                GuiGameElement.of((ItemStack)item).at((float)(posX + 10), (float)(posY - 16), 450.0f).render(guiGraphics);
                if (!Mods.MODERNUI.isLoaded()) {
                    RemovedGuiUtils.drawHoveringText((GuiGraphics)guiGraphics, tooltip, (int)posX, (int)posY, (int)n, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
                    poseStack.popPose();
                    return;
                }
                MouseHandler mouseHandler = Minecraft.getInstance().mouseHandler;
                Window window = Minecraft.getInstance().getWindow();
                double guiScale = window.getGuiScale();
                double cursorX = mouseHandler.xpos();
                double cursorY = mouseHandler.ypos();
                ((MouseHandlerAccessor)mouseHandler).create$setXPos((double)Math.round(cursorX / guiScale) * guiScale);
                ((MouseHandlerAccessor)mouseHandler).create$setYPos((double)Math.round(cursorY / guiScale) * guiScale);
                RemovedGuiUtils.drawHoveringText((GuiGraphics)guiGraphics, tooltip, (int)posX, (int)posY, (int)n, (int)height, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (Font)mc.font);
                ((MouseHandlerAccessor)mouseHandler).create$setXPos(cursorX);
                ((MouseHandlerAccessor)mouseHandler).create$setYPos(cursorY);
                poseStack.popPose();
            }
        }
    }

    @Shadow
    public static BlockPos proxiedOverlayPosition(Level level, BlockPos pos) {
        BlockState targetedState = level.getBlockState(pos);
        Block block = targetedState.getBlock();
        if (block instanceof IProxyHoveringInformation) {
            IProxyHoveringInformation proxy = (IProxyHoveringInformation)block;
            return proxy.getInformationSource(level, pos, targetedState);
        }
        return pos;
    }
}

