/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.recipes.jei;

import com.drmangotea.tfmg.recipes.VatMachineRecipe;
import com.drmangotea.tfmg.registry.TFMGGuiTextures;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.apache.commons.lang3.mutable.MutableInt;

public class ChemicalVatCategory
extends CreateRecipeCategory<VatMachineRecipe> {
    public ChemicalVatCategory(CreateRecipeCategory.Info<VatMachineRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VatMachineRecipe recipe, IFocusGroup focuses) {
        int itemMovement;
        int movement;
        int fluidCount = recipe.getFluidIngredients().size();
        int pos = 55;
        int width = fluidCount * 20 / 2;
        int n = movement = fluidCount != 4 ? 1 : 0;
        if (fluidCount == 1) {
            movement = 2;
        }
        for (int i = 0; i < fluidCount; ++i) {
            ChemicalVatCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)(pos - width + movement), (int)(recipe.getIngredients().isEmpty() ? 72 : 85), (SizedFluidIngredient)((SizedFluidIngredient)recipe.getFluidIngredients().get(i)));
            pos += 21;
        }
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.getIngredients());
        int itemCount = condensedIngredients.size();
        int itemPos = 55;
        int itemWidth = itemCount * 20 / 2;
        int n2 = itemMovement = itemCount != 4 ? 1 : 0;
        if (itemCount == 1) {
            itemMovement = 2;
        }
        for (Pair pair : condensedIngredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).getItems()) {
                ItemStack copy = itemStack.copy();
                copy.setCount(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, itemPos - itemWidth + itemMovement, recipe.getFluidIngredients().isEmpty() ? 72 : 64).setBackground(ChemicalVatCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            itemPos += 21;
        }
        int fluidResultPos = 90;
        for (int i = 0; i < recipe.getFluidResults().size(); ++i) {
            ChemicalVatCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)150, (int)fluidResultPos, (FluidStack)((FluidStack)recipe.getFluidResults().get(i)));
            fluidResultPos -= 21;
        }
        int itemResultPos = 90;
        for (int i = 0; i < recipe.getRollableResults().size(); ++i) {
            ProcessingOutput output = (ProcessingOutput)recipe.getRollableResults().get(i);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 128, itemResultPos).setBackground(ChemicalVatCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(ChemicalVatCategory.addStochasticTooltip((ProcessingOutput)output));
            itemResultPos -= 21;
        }
    }

    public void draw(VatMachineRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        List<String> machines = recipe.machines;
        List<String> allowedVatTypes = recipe.allowedVatTypes;
        TFMGGuiTextures.VAT.render(graphics, 0, 24);
        this.drawVatTypes(allowedVatTypes, graphics);
        this.drawSprites(machines, graphics);
        this.renderHeated(recipe.getRequiredHeat(), graphics);
        int pos = 55;
        int width = recipe.getFluidIngredients().size() * 21 / 2;
        for (int i = 0; i < recipe.getFluidIngredients().size(); ++i) {
            TFMGGuiTextures.SLOT.render(graphics, pos - width, recipe.getIngredients().isEmpty() ? 70 : 83);
            pos += 21;
        }
        int posItem = 55;
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.getIngredients());
        int widthItem = condensedIngredients.size() * 21 / 2;
        for (int i = 0; i < condensedIngredients.size(); ++i) {
            TFMGGuiTextures.SLOT.render(graphics, posItem - widthItem, recipe.getFluidIngredients().isEmpty() ? 70 : 62);
            posItem += 21;
        }
    }

    private void renderHeated(HeatCondition heatCondition, GuiGraphics graphics) {
        if (heatCondition == HeatCondition.HEATED) {
            TFMGGuiTextures.VAT_HEATER.render(graphics, 45, 109);
        }
        if (heatCondition == HeatCondition.SUPERHEATED) {
            TFMGGuiTextures.VAT_SUPERHEATER.render(graphics, 45, 109);
        }
    }

    private void drawVatTypes(List<String> allowedVatTypes, GuiGraphics graphics) {
        if (allowedVatTypes.contains("tfmg:firebrick_lined_vat") && allowedVatTypes.size() == 1) {
            TFMGGuiTextures.FIREPROOF_BRICK_OVERLAY.render(graphics, 7, 32);
        }
        if (allowedVatTypes.contains("tfmg:cast_iron_vat") && allowedVatTypes.size() == 1) {
            TFMGGuiTextures.CAST_IRON_VAT_OVERLAY.render(graphics, 0, 24);
        }
    }

    private void drawSprites(List<String> machines, GuiGraphics graphics) {
        if (machines.contains("tfmg:mixing")) {
            TFMGGuiTextures.VAT_MACHINE.render(graphics, 43, 0);
            TFMGGuiTextures.MIXER.render(graphics, 36, 32);
        }
        if (machines.contains("tfmg:centrifuge")) {
            TFMGGuiTextures.VAT_MACHINE.render(graphics, 43, 0);
            TFMGGuiTextures.CENTRIFUGE.render(graphics, 43, 32);
        }
        if (machines.contains("tfmg:electrode")) {
            TFMGGuiTextures.VAT_MACHINE.render(graphics, 11, 0);
            TFMGGuiTextures.VAT_MACHINE.render(graphics, 75, 0);
            TFMGGuiTextures.ELECTRODE.render(graphics, 20, 32);
            TFMGGuiTextures.ELECTRODE.render(graphics, 84, 32);
        }
        if (machines.contains("tfmg:graphite_electrode")) {
            TFMGGuiTextures.VAT_MACHINE.render(graphics, 11, 0);
            TFMGGuiTextures.VAT_MACHINE.render(graphics, 75, 0);
            TFMGGuiTextures.VAT_MACHINE.render(graphics, 43, 0);
            TFMGGuiTextures.GRAPHITE_ELECTRODE.render(graphics, 19, 32);
            TFMGGuiTextures.GRAPHITE_ELECTRODE.render(graphics, 83, 32);
            TFMGGuiTextures.GRAPHITE_ELECTRODE.render(graphics, 51, 32);
        }
    }
}

